

;=====================================================================================================================================================
;																									
;	( DIREC-ALA-74 )	=>		**** ( DIVIDE hasta 16.384 ) ****														
;																									
;	GRAFICA INTERSECCION SUPERFICIE TOPOGRAFICA (PUNTOS) CON PLANO X-Y													
;																									
;	CON NUEVOS ALGORIZMOS en (TANG.) y (SENO) MAS SENCILLOS sin (COMMAND...... )												
;																									
;	(TANG.) => TRASLACION DE PUNTO   (SENO) => CALCULO POR DETERMINANDES (SI (P4) ESTA EN PLANO (P1 P2 P3))							
;																									
;	GRAFICA (PUNTOS) INTERSECCION SUPERFICIE GRAFICA  CON PLANO X-Y														
;																									
;	PINTA 3D-CARA EN 3D Y 2D																				
;																									
;	BUSCA (NBx) en TRAMO PUNTOS-SALTO (Psat) cada NBx=1 																
;																									
;	*** OTRO ALGORIZMO ***  EN FORMACION DE (LISTA-3D) CON (LISTA-PUN) *((/= LGbaX nil) (=  LGsuX nil))* *((<  Npu  N1maxi  N2mini))*			
;																									
;=====================================================================================================================================================



;=====================================================================================================================================================
;	CALCULO POR DETERMINANDES (LOS 4 PUNTOS  (P1)-(X1 Y1 Z1)   (P2)-(X2 Y2 Z2)   (P3)-(X3 Y3 Z3)   (P4)-(X4 Y4 Z4)  SON COPLANARIOS) => SI		
;=====================================================================================================================================================
;																									
;	| X1 Y1 Z1 1 |																						
;	| X2 Y2 Z2 1 |																						
;	| X3 Y3 Z3 1 | = 0    =>  ( 4 PUNTOS Coplanarios )																
;	| X4 Y4 Z4 1 |																						
;																									
;=====================================================================================================================================================
;	ADJUNTOS (de un ELEMENTO al VALOR del MENOR COMPLEMENTARIO con SIGNO (+) o (-) segun sea par o impar la suma de los subindices)			
;=====================================================================================================================================================
;																									
;	|    X1      Y1      Z1   1 |																				
;	| (X1-X2) (Y1-Y2) (Z1-Z2) 0 |																				
;	| (X1-X3) (Y1-Y3) (Z1-Z3) 0 | = 0    =>  ( 4 PUNTOS Coplanarios )														
;	| (X1-X4) (Y1-Y4) (Z1-Z4) 0 |																				
;																									
;	| (X1-X2) (Y1-Y2) (Z1-Z2) |																				
;	| (X1-X3) (Y1-Y3) (Z1-Z3) | = 0    =>  ( 4 PUNTOS Coplanarios )														
;	| (X1-X4) (Y1-Y4) (Z1-Z4) |																				
;																									
;=====================================================================================================================================================
;	Un determinante es igual a la SUMA de los PRODOCTOS de los ELEMENTOS de una linea por sus respectivos ADJUNTOS						
;=====================================================================================================================================================
;																									
;	(SETQ MM0 (- (+ (* (- X1 X4) (- Y1 Y3) (- Z1 Z2)) (* (- X1 X3) (- Y1 Y2) (- Z1 Z4)) (* (- X1 X2) (- Y1 Y4) (- Z1 Z3)) )					
;			 (+ (* (- X1 X2) (- Y1 Y3) (- Z1 Z4)) (* (- X1 X3) (- Y1 Y4) (- Z1 Z2)) (* (- X1 X4) (- Y1 Y2) (- Z1 Z3)) ) ) )				
;																									
;=====================================================================================================================================================


;=====================================================================================================================================================
;	(PUNTOS-X) = PUNTEA CURVA A N DIVISIONES (Nd) => (LISTA-PX)														
;=====================================================================================================================================================

(DEFUN PUNTOS-X (/  )

	(SETQ	AELES (MEMBER (ASSOC 10 (ENTGET NE-3D)) (ENTGET NE-3D))					; lista a partir del elemento (incluido)
		A-primer (CDR (NTH 0 AELES))										; primer elemento
		A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)) )						; ultimo elemento

	(SETQ NN Nd)

	(SETQ NNN ( STRCAT (ITOA NN) "  ESPERE" ))

	(COMMAND "COLOR" 2 "TEXTO" (LIST (* 50 Ftex) (* 450 Ftex) 0) (* 80 Ftex) "90" NNN) (SETQ TT (ENTLAST))

	(COMMAND 	"COLOR"   1 "PUNTO"  A-primer)								; PINTA Primer Punto (en Base de Datos)
 	(SETQ NPA0 (ENTLAST))												; Nombre ultima entidad principal = 1 punto
	(COMMAND	"COLOR" 252 "DIVIDE" NE-3D Nd									; PINTA Punto Divide (en Base de Datos)
			"COLOR"   5 "PUNTO"  A-ultimo)								; PINTA Ultimo Punto (en Base de Datos)

	;	PUNTOS SECCION X (PX1-PXn) =>  LISTA-PX																	

	(SETQ	NPA1 nil
		NPA2 nil
		LISTA-PX nil
		NPA2 NPA0
		LISTA-PX (LIST (CDR (ASSOC 10 (ENTGET NPA0))))											; LISTA-PX => 1 punto
		WH-1 T )

	(WHILE WH-1
	  		(SETQ NPA1 (ENTNEXT NPA0)													; nombre entidad siguiente
				
			NN (- NN 1) )

			(COND ( (= (REM NN 100) 0)
				  (ENTDEL TT)
				  (COMMAND "COLOR" 2 "TEXTO" (LIST (* 50 Ftex) (* 450 Ftex) 0) (* 80 Ftex) "90" NN)
				  (SETQ TT (ENTLAST)) ))

			(IF (= NPA1 nil)	(SETQ WH-1 nil)
						(PROGN
							(SETQ LISTA-PX (CONS (CDR (ASSOC 10 (ENTGET NPA1))) LISTA-PX)  NPA0 NPA1 )	;=> resto PUNTOS con ULTIMO
							(ENTDEL NPA1)											; BORRA PUNTO
						)
			)
	)
	(SETQ LISTA-PX (REVERSE LISTA-PX))

	(ENTDEL NPA2)																	; BORRA PUNTO

) ;cierre DEFUN PUNTOS-X

;	en LISTA (PUNTOS-X)  Estan los Puntos ( Punto-Prinero  Puntos-Divide  Punto-Ultimo )	Total Puntos ((NDivide - 1) + 2)				

;=====================================================================================================================================================


;=====================================================================================================================================================
;	(BUSCA-AB)  Entrada => (Naa Nbb)  Salida => (AAx BBx NBxx)															
;=====================================================================================================================================================

(DEFUN BUSCA-AB (/  )

	;	PUNTOS B																						
	(SETQ WW Nbb 
		B1* (NTH (- Nbb 1) LISTA-PB)
		B2* (NTH (+ Nbb 0) LISTA-PB)
		B3* (NTH (+ Nbb 1) LISTA-PB) )

	; Tangente en B2* => (TB0x-TBTx)																			
	(SETQ TB0x 	B2*
		TBTx 	(LIST (+ (CAR   B3*) (- (CAR   B2*) (CAR   B1*)))
				(+ (CADR  B3*) (- (CADR  B2*) (CADR  B1*)))
				(+ (CADDR B3*) (- (CADDR B2*) (CADDR B1*)))) )

  	; (MM1=0) => 4 PUNTOS COPLANARIOS 																			
	(SETQ X1 (CAR TBTx)  Y1 (CADR TBTx)  Z1 (CADDR TBTx)
		X2 (CAR TB0x)  Y2 (CADR TB0x)  Z2 (CADDR TB0x)
		X3 (CAR TATx)  Y3 (CADR TATx)  Z3 (CADDR TATx)
		X4 (CAR TA0x)  Y4 (CADR TA0x)  Z4 (CADDR TA0x) )

	(SETQ MM1 (- (+ (* (- X1 X4) (- Y1 Y3) (- Z1 Z2)) (* (- X1 X3) (- Y1 Y2) (- Z1 Z4)) (* (- X1 X2) (- Y1 Y4) (- Z1 Z3)) )
			 (+ (* (- X1 X2) (- Y1 Y3) (- Z1 Z4)) (* (- X1 X3) (- Y1 Y4) (- Z1 Z2)) (* (- X1 X4) (- Y1 Y2) (- Z1 Z3)) ) ) )

	(SETQ Wbb T)
	(WHILE Wbb
		;	PUNTOS B																					
		(SETQ Nbb (+ Nbb 1)
		  	B1* (NTH (- Nbb 1) LISTA-PB)
			B2* (NTH (+ Nbb 0) LISTA-PB)
			B3* (NTH (+ Nbb 1) LISTA-PB) )

		(IF (> Nbb (+ WW Psal)) (SETQ Wbb nil))

		(IF (= B3* nil) (SETQ Wbb nil)

			(PROGN

				; Tangente en B2* => (TB0x-TBTx)																
				(SETQ TB0x 	B2*
					TBTx 	(LIST (+ (CAR   B3*) (- (CAR   B2*) (CAR   B1*)))
							(+ (CADR  B3*) (- (CADR  B2*) (CADR  B1*)))
							(+ (CADDR B3*) (- (CADDR B2*) (CADDR B1*)))) )

  				; (MM1=0) => 4 PUNTOS COPLANARIOS 																
				(SETQ X1 (CAR TBTx)  Y1 (CADR TBTx)  Z1 (CADDR TBTx)
					X2 (CAR TB0x)  Y2 (CADR TB0x)  Z2 (CADDR TB0x)
					X3 (CAR TATx)  Y3 (CADR TATx)  Z3 (CADDR TATx)
					X4 (CAR TA0x)  Y4 (CADR TA0x)  Z4 (CADDR TA0x))

				(SETQ MM2 (- (+ (* (- X1 X4) (- Y1 Y3) (- Z1 Z2)) (* (- X1 X3) (- Y1 Y2) (- Z1 Z4)) (* (- X1 X2) (- Y1 Y4) (- Z1 Z3)) )
			 			 (+ (* (- X1 X2) (- Y1 Y3) (- Z1 Z4)) (* (- X1 X3) (- Y1 Y4) (- Z1 Z2)) (* (- X1 X4) (- Y1 Y2) (- Z1 Z3)) ) ) )

				;	PUNTO MMx=0 entre (MM1-MM2)  subiendo o bajando													

				(COND
					( (OR (AND (> MM1 0) (<= MM2 0)) (AND (< MM1 0) (>= MM2 0))) ; cond 1

						(SETQ

							; Punto AAx = A2*			
							AAx A2*

							; Punto BBx entre B1* y B2*	
							FAb (/ (ABS MM1) (+ (ABS MM1) (ABS MM2)))
							Xb1 (CAR B1*) Yb1 (CADR B1*) Zb1 (CADDR B1*)
							Xb2 (CAR B2*) Yb2 (CADR B2*) Zb2 (CADDR B2*)
							XBo (+ (* FAb (- Xb2 Xb1)) Xb1)
							YBo (+ (* FAb (- Yb2 Yb1)) Yb1)
							ZBo (+ (* FAb (- Zb2 Zb1)) Zb1)

							BBx (LIST XBo YBo ZBo)

							; NBxx entre (- Nbb 1) y Nbb	
							NBxx (+ (- Nbb 1) (/ (ABS MM1) (+ (ABS MM1) (ABS MM2))))

							; Para While
							Wbb nil

						) ; setq
					) ; cond 1
				) ; COND

				(SETQ MM1 MM2 )
			) ; progn
		) ; if
	) ; cierre while
) ;cierre DEFUN BUSCA-AB

;=====================================================================================================================================================


;=====================================================================================================================================================
;	LISTA-Puntos																						
;=====================================================================================================================================================

(DEFUN LISTA-Puntos (/  )

  	(SETQ COL (+ COL 1)

		PUNTO-BA nil
		PUNTO-SU nil

		PG-ba nil
		PGaa1 nil
		PGbb1 nil

		PG-su nil
		PGaa2 nil
		PGbb2 nil 
	)

	;	TRES PUNTOS CONSECUTIVOS LISTA-PB																		
	(SETQ NBx 1

		B1* (NTH (- NBx 1) LISTA-PB)
		B2* (NTH (+ NBx 0) LISTA-PB)
		B3* (NTH (+ NBx 1) LISTA-PB) )

	; Tangente (TB0x-TBTx)																					
	(SETQ TB0x 	B2*
		TBTx 	(LIST (+ (CAR   B3*) (- (CAR   B2*) (CAR   B1*)))
				(+ (CADR  B3*) (- (CADR  B2*) (CADR  B1*)))
				(+ (CADDR B3*) (- (CADDR B2*) (CADDR B1*)))) )

  	; 4 PUNTOS COPLANARIOS (MM1=0)																			
	(SETQ X1 (CAR TBTx)  Y1 (CADR TBTx)  Z1 (CADDR TBTx)
		X2 (CAR TB0x)  Y2 (CADR TB0x)  Z2 (CADDR TB0x)
		X3 (CAR TATx)  Y3 (CADR TATx)  Z3 (CADDR TATx)
		X4 (CAR TA0x)  Y4 (CADR TA0x)  Z4 (CADDR TA0x)

		MM1 (- (+ (* (- X1 X4) (- Y1 Y3) (- Z1 Z2)) (* (- X1 X3) (- Y1 Y2) (- Z1 Z4)) (* (- X1 X2) (- Y1 Y4) (- Z1 Z3)) )
			 (+ (* (- X1 X2) (- Y1 Y3) (- Z1 Z4)) (* (- X1 X3) (- Y1 Y4) (- Z1 Z2)) (* (- X1 X4) (- Y1 Y2) (- Z1 Z3)) ) ) )


	(SETQ Wb1 T  )
	(WHILE Wb1

		(SETQ NBx (+ NBx Psal)

		  	B1* (NTH (- NBx 1) LISTA-PB)
			B2* (NTH (+ NBx 0) LISTA-PB)
			B3* (NTH (+ NBx 1) LISTA-PB) )

		(IF (= B3* nil) (SETQ Wb1 nil)

			(PROGN

				(SETQ PG-ba nil
					PG-su nil )

				; Tangente (TB0x-TBTx)																		
				(SETQ TB0x 	B2*
					TBTx 	(LIST (+ (CAR   B3*) (- (CAR   B2*) (CAR   B1*)))
							(+ (CADR  B3*) (- (CADR  B2*) (CADR  B1*)))
							(+ (CADDR B3*) (- (CADDR B2*) (CADDR B1*)))) )

  				; 4 PUNTOS COPLANARIOS (MM1=0)																
				(SETQ X1 (CAR TBTx)  Y1 (CADR TBTx)  Z1 (CADDR TBTx)
					X2 (CAR TB0x)  Y2 (CADR TB0x)  Z2 (CADDR TB0x)
					X3 (CAR TATx)  Y3 (CADR TATx)  Z3 (CADDR TATx)
					X4 (CAR TA0x)  Y4 (CADR TA0x)  Z4 (CADDR TA0x)

					MM2 (- (+ (* (- X1 X4) (- Y1 Y3) (- Z1 Z2)) (* (- X1 X3) (- Y1 Y2) (- Z1 Z4)) (* (- X1 X2) (- Y1 Y4) (- Z1 Z3)) )
			 			 (+ (* (- X1 X2) (- Y1 Y3) (- Z1 Z4)) (* (- X1 X3) (- Y1 Y4) (- Z1 Z2)) (* (- X1 X4) (- Y1 Y2) (- Z1 Z3)) ) ) )




				;	(PUNTO-BA)  (PUNTO-SU)																	

				(COND
					;	(Grafica BAJANDO) => PUNTO-BA ( PG-ba PGaa1 PGbb1 AAx BBx COL1 )									

					( (AND (> MM1 0) (<= MM2 0) (= PG-ba nil))

						(SETQ Nbb (- NBx Psal))

						(BUSCA-AB)

						(IF (= (REM COL 10) 0) (SETQ COL1 30) (SETQ COL1 (REM COL 10)))

						(SETQ PG-ba (LIST (* NBxx FACg) (* NAx FACg))
							PGaa1 (LIST (* NAx  FACg) (- (/ EJExy  2)))
							PGbb1 (LIST (* NBxx FACg) (- (/ EJExy 20)))

							PUNTO-BA (LIST PG-ba PGaa1 PGbb1 AAx BBx COL1) )
					 
					) ; cond 1

					;	(Grafica SUBIENDO) => PUNTO-SU ( PG-su PGaa2 PGbb2 AAx BBx COL2 )									

					( (AND (< MM1 0) (>= MM2 0) (= PG-su nil))

						(SETQ Nbb (- NBx Psal))

						(BUSCA-AB)

						(IF (= (REM COL 10) 0) (SETQ COL2 30) (SETQ COL2 (REM COL 10)) )

						(SETQ PG-su (LIST (* NBxx FACg) (* NAx FACg))
							PGaa2 (LIST (* NAx  FACg) (- (/ EJExy  2)))
							PGbb2 (LIST (* NBxx FACg) (- (/ EJExy 20)))

							PUNTO-SU (LIST PG-su PGaa2 PGbb2 AAx BBx COL2) )

					) ; cond 2
				) ; COND

				(SETQ MM1 MM2 )

			) ; cierre PROGN Wb1
		) ; cierre IF Wb1
	) ; cierre WHILE Wb1
) ;cierre DEFUN LISTA-Puntos

;=====================================================================================================================================================




;*****************************************************************************************************************************************************
;=====================================================================================================================================================
;																									
;       *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** PROGRAMA***PROGRAMA***PROGRAMA***PROGRAMA***PROGRAMA***		
;																									
;=====================================================================================================================================================

(DEFUN C:DIREC-ALA-74 (/ )
  
;	ARRANCANDO																							
  
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "SCP" "U") (COMMAND "-REFENT" "DES") (COMMAND "ORTO" "DES")
	(COMMAND "-UNIDADES" 2 3 1 3 "0" "S") (COMMAND "-UNIDADES" 2 3 1 3 "270" "S") ;  ERROR ??????
  
;=====================================================================================================================================================
;	FIJAR VARIABLES EN EL PROGRAMA																			
;=====================================================================================================================================================

;	VALORES de (Nd) (CARAS) y (Psal) =>   2  4  8  16  32  64  128  256  512  1024  2048  4096  8192  16384  NO-32768	( MULPLIPOS de DOS )		

					(SETQ Nd      4096)				; N (DIVIDE) CURVAS

					(SETQ CARAS     64)				; CUANTAS CARAS POR TIRA

					(SETQ Psal      64)				; PUNTOS por SALTO en NBx

					(SETQ EJExy     100)				; DIMENSIONES (Grafica) EJE-X e Y 

;=====================================================================================================================================================

	;	TEXTO EN PANTALLA DATOS																				

	(SETQ
		Ftex 	(/ (FLOAT EJExy) 1000)
		Yn	(- (* (- 35) Ftex) (/ EJExy 2))
		Htex	(* 18 Ftex)  )


  	(COMMAND  	"COLOR" 5	"TEXTO" (LIST    0         Yn 0) Htex "90"  "DIREC-ALA-74"
			"COLOR" 1	"TEXTO" (LIST (* 230 Ftex) Yn 0)  ""   ""  (STRCAT  "Nd = "    (ITOA Nd))
		 	 		"TEXTO" (LIST (* 398 Ftex) Yn 0)  ""   ""  (STRCAT  "CARAS = " (ITOA CARAS))
					"TEXTO" (LIST (* 585 Ftex) Yn 0)  ""   ""  (STRCAT  "Psal = "  (ITOA Psal))
					"TEXTO" (LIST (* 766 Ftex) Yn 0)  ""   ""  (STRCAT  "EJExy = " (ITOA (FIX EJExy)))
			"COLOR" 8   "RECTANG" (LIST 0 0) (LIST EJExy EJExy)
	  				"LINEA"   (LIST 0 0) (LIST EJExy EJExy) ""
					"RECTANG" (LIST 0 (- (/ EJExy 2))) (LIST EJExy (- (/ EJExy 20)))  )

	;	LISTA-PA  LISTA-PB																				

	(SETQ E-3D (ENTSEL "  Seleciona (1) Curva Alabeada   *** 1 BASE ***")) (TERPRI)
 	(SETQ NE-3D (CAR E-3D)) (PUNTOS-X)

	(SETQ   LISTA-PA  LISTA-PX   PrimerA  A-primer   UltimoA  A-ultimo )

	(COMMAND "COLOR" 7 "TEXTO" "D" A-primer Htex "90" "A___")


	(SETQ E-3D (ENTSEL "  Seleciona (2) Curva Alabeada   *** 2 XXXX ***")) (TERPRI) (TERPRI) (TERPRI)
 	(SETQ NE-3D (CAR E-3D)) (PUNTOS-X)

	(SETQ   LISTA-PB  LISTA-PX   PrimerB  A-primer   UltimoB  A-ultimo )

	(COMMAND "COLOR" 7 "TEXTO" "D" A-primer Htex "90" "B___") 

 
	;	ESCRIBE " ESPERE "																				

	(COMMAND "COLOR" 2 "TEXTO" (LIST (* 50 Ftex) (* 450 Ftex) 0) (* 150 Ftex) "90" " ESPERE") (SETQ TTT (ENTLAST))

  	;	VALOR INICIO VARIABLES																				

	(SETQ Nna 0
		FACna (/ Nd CARAS)
		FACg (/ EJExy (FLOAT Nd))

		COL 11

		PP0 	(LIST (* 1500 Ftex) (*  1000 Ftex)    0)
		PPX 	(LIST   (CAR PP0)   (- (CADR PP0) 10) 0) 			; (PP0 PPX) EJE INICIO 3DCARAS-2D PATRONES

		LISTA-PUN nil )

	;	PROGRAMA																						


	;	TRES PUNTOS CONSECUTIVOS LISTA-PA																		

	(SETQ Nna (+ Nna 1)
		NAx (* Nna FACna)

		A1* (NTH (- NAx 1) LISTA-PA)
		A2* (NTH (+ NAx 0) LISTA-PA)
		A3* (NTH (+ NAx 1) LISTA-PA) )

	; Tangente en A2* => (TA0x TATx)					
	(SETQ	TA0x 	A2*
		TATx 	(LIST (+ (CAR   A3*) (- (CAR   A2*) (CAR   A1*)))
				(+ (CADR  A3*) (- (CADR  A2*) (CADR  A1*)))
				(+ (CADDR A3*) (- (CADDR A2*) (CADDR A1*)))))

  	(LISTA-Puntos)

	(SETQ LISTA-PUN (CONS (LIST PUNTO-BA PUNTO-SU) LISTA-PUN) )

	(SETQ Wa1 T)
	(WHILE Wa1

		(SETQ Nna (+ Nna 1))

		(IF (= Nna CARAS) (SETQ Wa1 nil)

			(PROGN

				(SETQ NAx (* Nna FACna)

					A1* (NTH (- NAx 1) LISTA-PA)
					A2* (NTH (+ NAx 0) LISTA-PA)
					A3* (NTH (+ NAx 1) LISTA-PA) )

				; Tangente en A2* => (TA0x TATx)					
				(SETQ	TA0x 	A2*
					TATx 	(LIST (+ (CAR   A3*) (- (CAR   A2*) (CAR   A1*)))
							(+ (CADR  A3*) (- (CADR  A2*) (CADR  A1*)))
							(+ (CADDR A3*) (- (CADDR A2*) (CADDR A1*)))))

				(LISTA-Puntos)

				(SETQ LISTA-PUN (CONS (LIST PUNTO-BA PUNTO-SU) LISTA-PUN) )

			)  ; progn
		)  ; if
	)  ; WHILE Wa1


	; ----------------------------------------------------------------------------------------------------------------------------------------------
	;	COMPRUEBA PUNTOS ALA IZQUIERDA (MENOR X) de (PG-ba) o (PG-su) en LISTA-PUN											
	;																								
	;	LISTA-PUN => ( ( PG-ba PGaa1 PGbb1 AAx BBx COL1 ) ( PG-su PGaa2 PGbb2 AAx BBx COL2 ) )									
	; ----------------------------------------------------------------------------------------------------------------------------------------------

	(SETQ Npu (- 1)
		N1     0
		N2     0  )
	
	(REPEAT (LENGTH LISTA-PUN)

		(SETQ Npu (+ Npu 1)

		  	Lpu 	(NTH Npu LISTA-PUN)

			LG1	(CAR  Lpu)
			LG2	(CADR Lpu) )

		(COND ( 	(AND (/= LG1 nil) (/= LG2 nil))

				(COND ( 	(< (CAR (CAR LG1)) (CAR (CAR LG2)) )

						(SETQ N1 (+ N1 1))
					)

					(	(> (CAR (CAR LG1)) (CAR (CAR LG2)) )

						(SETQ N2 (+ N2 1))
					)
				) ; cond
			)
		) ; cond
  	) ; repeat


	(SETQ LISTA-PUN1 nil)

	(COND ( 	(> N2 N1)

			(SETQ Npu (- 1) )

			(REPEAT (LENGTH LISTA-PUN)

				(SETQ Npu (+ Npu 1)

		  			Lpu 	(NTH Npu LISTA-PUN) )

					(SETQ LISTA-PUN1 (CONS (REVERSE Lpu) LISTA-PUN1) )
		   	) ; repeat
		)

		( 	(< N2 N1)

			(SETQ LISTA-PUN1 (REVERSE LISTA-PUN) )
		) 
	) ; cond


	; ----------------------------------------------------------------------------------------------------------------------------------------------

	;	LISTA-PUN1 (PRIMER PAR-PUNTO)																			

	(SETQ PP1 (LIST (LIST (LIST 0 0) (LIST 0 (- (/ EJExy  2))) (LIST 0 (- (/ EJExy 20))) PrimerA PrimerB 1) nil) )

	;	LISTA-PUN1 (ULTIMO PAR-PUNTO)																			

	(SETQ PP2 (LIST nil (LIST (LIST EJExy EJExy) (LIST EJExy (- (/ EJExy  2))) (LIST EJExy (- (/ EJExy 20))) UltimoA  UltimoB  5)) )


	(SETQ LISTA-PUN1 (CONS PP1 LISTA-PUN1) )

	(SETQ LISTA-PUN1 (REVERSE  LISTA-PUN1) )

	(SETQ LISTA-PUN1 (CONS PP2 LISTA-PUN1) )

	(SETQ LISTA-PUN  (REVERSE  LISTA-PUN1) )


	;	BORRA " ESPERE "																					

	(ENTDEL TTT)

	;	PINTA PUNTOS DE LA GRAFICA DE LISTA-PUN => ( ( PG-IZ PGaa1 PGbb1 AAx BBx COL1 ) ( PG-DE PGaa2 PGbb2 AAx BBx COL2 ) )				

	(SETQ Npu (- 1))

	(REPEAT (LENGTH LISTA-PUN)

		(SETQ Npu (+ Npu 1)

		  	Lpu 	(NTH Npu LISTA-PUN)

			LG1	(CAR  Lpu)
			LG2	(CADR Lpu) )

		(COND
			(  (AND (=  LG1 nil) (=  LG2 nil))	(PRIN1 "  NINGUNO DE DOS PUNTOS DE LA GRAFICA EXISTEN ") (TERPRI)		)

			(  (AND (/= LG1 nil) (=  LG2 nil))	(COMMAND "COLOR" 1 "PUNTO" (CAR LG1))						)

			(  (AND (=  LG1 nil) (/= LG2 nil))	(COMMAND "COLOR" 2 "PUNTO" (CAR LG2))						)

			(  (AND (/= LG1 nil) (/= LG2 nil))	(COMMAND "COLOR" 1 "PUNTO" (CAR LG1) "COLOR" 2 "PUNTO" (CAR LG2))		)

			(  T						(PRIN1 "  NO CUMPLE CONDICION PUNTOS GRAFICA ") (TERPRI)			)

		) ; cond

  	) ; repeat


	;	(MAXIMO X IZQUIERDA) (MINIMO X DERECHA) de LISTA-PUN => ( ( PG-IZ PGaa1 PGbb1 AAx BBx COL1 ) ( PG-DE PGaa2 PGbb2 AAx BBx COL2 ) )		


	(SETQ Npu 0 )

	(REPEAT (- (LENGTH LISTA-PUN) 2)

		(SETQ Npu (+ Npu 1)

		  	Lpu1 (NTH (- Npu 1) LISTA-PUN)   Liz1 (CAR  Lpu1)   XPiz1 (CAR (CAR Liz1))   Lde1 (CADR Lpu1)   XPde1 (CAR (CAR Lde1))
		  	Lpu2 (NTH    Npu    LISTA-PUN)   Liz2 (CAR  Lpu2)   XPiz2 (CAR (CAR Liz2))   Lde2 (CADR Lpu2)   XPde2 (CAR (CAR Lde2))
		  	Lpu3 (NTH (+ Npu 1) LISTA-PUN)   Liz3 (CAR  Lpu3)   XPiz3 (CAR (CAR Liz3))   Lde3 (CADR Lpu3)   XPde3 (CAR (CAR Lde3))  )


		(COND ( (AND (/= Liz1 nil) (/= Liz2 nil) (/= Liz3 nil) (> XPiz2 XPiz1) (> XPiz2 XPiz3) )

			 												(SETQ  P1maxi (CAR Liz2)  N1maxi Npu )

															(COMMAND "COLOR" 7   "PUNTO" P1maxi )   ))

		(COND ( (AND (/= Lde1 nil) (/= Lde2 nil) (/= Lde3 nil) (< XPde2 XPde1) (< XPde2 XPde3) )

			 												(SETQ  P2mini (CAR Lde2)  N2mini Npu )

															(COMMAND "COLOR" 7   "PUNTO" P2mini )   ))
  	) ; repeat


	;	CONDICION  MAXIMO MINIMO																			
  
	;(COMMAND "COLOR" 7   "PUNTO" P1maxi  "PUNTO" P2mini)

	(COND
		( 	(< (- N1maxi N2mini) 0)  	(PRIN1 " ( N2mini ) MAYOR QUE ( N1maxi ) */*/* MALO */*/* ") (TERPRI)  	)
		( 	(= (- N1maxi N2mini) 0)    	(PRIN1 " ( N2mini ) IGUAL QUE ( N1maxi )    ** BUENO ** ")   (TERPRI)	)
		( 	(> (- N1maxi N2mini) 0)  	(SETQ N1maxi (- N1maxi (/ (- N1maxi N2mini) 2)) )  				)
		(	 T					(PRIN1 " NO CUMPLE CONDICION (MAXIMO MINIMO) ") 		 (TERPRI)  	)
	)


	;	LISTA-3D ( ( AAx BBx COL1) ( AAx BBx COL2) ) 	<=    LISTA-PUN ( ( PG-IZ PGaa1 PGbb1 AAx BBx COL1 ) ( PG-DE PGaa2 PGbb2 AAx BBx COL2 ) )	

	;	0  PG-IZ 	PUNTO GRAFICA PUNTOS	
	;	1  PGaa1 	PUNTO GRAFICA LINEAS	
	;	2  PGbb1 	PUNTO GRAFICA LINEAS	
	;	3  AAx 	PUNTO SPLINES 3D		
	;	4  BBx 	PUNTO SPLINES 3D		
	;	5  COL1 	COLOR				

	(SETQ LISTA-3D nil
		Npu (- 1) )

	(REPEAT (- (LENGTH LISTA-PUN) 1)

		(SETQ Npu (+ Npu 1)

		  	Lpu1 (NTH    Npu    LISTA-PUN)    Liz1 (CAR  Lpu1)    Lde1 (CADR Lpu1)
		  	Lpu2 (NTH (+ Npu 1) LISTA-PUN)    Liz2 (CAR  Lpu2)    Lde2 (CADR Lpu2) )

		(COND
			;	Puntos IZQUIERDA				
			(  	(AND 	(/= Liz1 nil) (=  Lde1 nil)
					(/= Liz2 nil) (=  Lde2 nil) )

				(COMMAND "COLOR" (NTH 5 Liz1) "LINEA" (NTH 0 Liz1) (NTH 0 Liz2) "")
			 
				(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Liz1) (NTH 2 Liz1) (NTH 3 Liz1) (NTH 4 Liz1) (NTH 5 Liz1))
								   (LIST (NTH 1 Liz2) (NTH 2 Liz2) (NTH 3 Liz2) (NTH 4 Liz2) (NTH 5 Liz2))  ) LISTA-3D) )
			)

			;	Puntos IZQUIERDA Y DOBLE		
			(  	(AND 	(/= Liz1 nil) (=  Lde1 nil)
					(/= Liz2 nil) (/= Lde2 nil) )

				(COMMAND "COLOR" (NTH 5 Liz1) "LINEA" (NTH 0 Liz1) (NTH 0 Liz2) "")
			 
				(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Liz1) (NTH 2 Liz1) (NTH 3 Liz1) (NTH 4 Liz1) (NTH 5 Liz1))
								   (LIST (NTH 1 Liz2) (NTH 2 Liz2) (NTH 3 Liz2) (NTH 4 Liz2) (NTH 5 Liz2))  ) LISTA-3D) )
			)

			;	Puntos DOBLES																			
			(  	(AND 	(/= Liz1 nil) (/= Lde1 nil)
					(/= Liz2 nil) (/= Lde2 nil) )

				(COND
					;	Punto DOBLE N<maxi		
					(  	(< Npu N1maxi)

					(COMMAND "COLOR" (NTH 5 Liz1) "LINEA" (NTH 0 Liz1) (NTH 0 Liz2) "")
					 
					(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Liz1) (NTH 2 Liz1) (NTH 3 Liz1) (NTH 4 Liz1) (NTH 5 Liz1))
									   (LIST (NTH 1 Liz2) (NTH 2 Liz2) (NTH 3 Liz2) (NTH 4 Liz2) (NTH 5 Liz2))  ) LISTA-3D) )
					)

					;	Punto DOBLE N=maxi y N>=mini
					(  	(AND (= Npu N1maxi) (>= Npu NBAmini))

					(COMMAND "COLOR" (NTH 5 Liz1) "LINEA" (NTH 0 Liz1) (NTH 0 Lde1) "")
					 
					(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Liz1) (NTH 2 Liz1) (NTH 3 Liz1) (NTH 4 Liz1) (NTH 5 Liz1))
									   (LIST (NTH 1 Lde1) (NTH 2 Lde1) (NTH 3 Lde1) (NTH 4 Lde1) (NTH 5 Lde1))  ) LISTA-3D) )

					(COMMAND "COLOR" (NTH 5 Liz2) "LINEA" (NTH 0 Lde1) (NTH 0 Lde2) "")
					 
					(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Lde1) (NTH 2 Lde1) (NTH 3 Lde1) (NTH 4 Lde1) (NTH 5 Lde2))
									   (LIST (NTH 1 Lde2) (NTH 2 Lde2) (NTH 3 Lde2) (NTH 4 Lde2) (NTH 5 Lde2))  ) LISTA-3D) )
					)

					;	Punto DOBLE N>=mini		
					(  	(>= Npu N2mini)

					(COMMAND "COLOR" (NTH 5 Lde2) "LINEA" (NTH 0 Lde1) (NTH 0 Lde2) "")
					 
					(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Lde1) (NTH 2 Lde1) (NTH 3 Lde1) (NTH 4 Lde1) (NTH 5 Lde2))
							 		   (LIST (NTH 1 Lde2) (NTH 2 Lde2) (NTH 3 Lde2) (NTH 4 Lde2) (NTH 5 Lde2))  ) LISTA-3D) )
					)
				)
			)
			;																						

			;	Puntos DOBLE Y DERECHA			
			(  	(AND 	(/= Liz1 nil) (/= Lde1 nil)
					(=  Liz2 nil) (/= Lde2 nil) )

				(COMMAND "COLOR" (NTH 5 Lde2) "LINEA" (NTH 0 Lde1) (NTH 0 Lde2) "")
			 
				(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Lde1) (NTH 2 Lde1) (NTH 3 Lde1) (NTH 4 Lde1) (NTH 5 Lde2))
								   (LIST (NTH 1 Lde2) (NTH 2 Lde2) (NTH 3 Lde2) (NTH 4 Lde2) (NTH 5 Lde2))  ) LISTA-3D) )
			)

			;	Puntos DERECHA				
			(  	(AND 	(=  Liz1 nil) (/= Lde1 nil)
					(=  Liz2 nil) (/= Lde2 nil) )

				(COMMAND "COLOR" (NTH 5 Lde2) "LINEA" (NTH 0 Lde1) (NTH 0 Lde2) "")
			 
				(SETQ LISTA-3D (CONS (LIST (LIST (NTH 1 Lde1) (NTH 2 Lde1) (NTH 3 Lde1) (NTH 4 Lde1) (NTH 5 Lde2))
								   (LIST (NTH 1 Lde2) (NTH 2 Lde2) (NTH 3 Lde2) (NTH 4 Lde2) (NTH 5 Lde2))  ) LISTA-3D) )
			)

		) ; cond
  	) ; repeat


	(SETQ LISTA-3D (REVERSE LISTA-3D))


	;	LINEAS PUNTOS 3D		 LISTA-3D => ( ( PGaa1 PGbb1 AAx BBx COL1) ( PGaa2 PGbb2 AAx BBx COL2) )							

	(SETQ Np3 (- 1))

	(REPEAT (LENGTH LISTA-3D)

		(SETQ Np3 (+ Np3 1)
		  	Lp1 (CAR  (NTH Np3 LISTA-3D))
		  	Lp2 (CADR (NTH Np3 LISTA-3D))

			G1A (NTH 0 Lp1) G1B (NTH 1 Lp1) P1A (NTH 2 Lp1) P1B (NTH 3 Lp1) Co1 (NTH 4 Lp1)
			G2A (NTH 0 Lp2) G2B (NTH 1 Lp2) P2A (NTH 2 Lp2) P2B (NTH 3 Lp2) Co2 (NTH 4 Lp2) )

		;	3DCARA (Superficie) 3D				
		(COMMAND "COLOR" Co1 "3DCARA" P1A P1B P2B P2A "")

		;	3DCARA (Grafica) 2D				
		(COMMAND "COLOR" Co1 "3DCARA" G1A G1B G2B G2A "")


		;	TRASFORMA 3DCARA (Superficie) 3D a 3DCARA (Superficie) 2D Plano Unibersal										

		(COMMAND "SCP" "3P" P1B P1A P2B)
  			(SETQ
				K1A (TRANS P1A  0 1)
				K2A (TRANS P1B  0 1)
				K3A (TRANS P2A  0 1)
				K4A (TRANS P2B  0 1)
			)
 		(COMMAND "SCP" "U")
		(COMMAND "SCP" "3P" PP0 PPX "")
			(SETQ
				K1X (TRANS K1A 1 0) K1X (LIST (CAR K1X) (CADR K1X) 0)
				K2X (TRANS K2A 1 0) K2X (LIST (CAR K2X) (CADR K2X) 0)
				K3X (TRANS K3A 1 0) K3X (LIST (CAR K3X) (CADR K3X) 0)
				K4X (TRANS K4A 1 0) K4X (LIST (CAR K4X) (CADR K4X) 0)
			)
 		(COMMAND "SCP" "U")

		;	3DCARA (Superficie) 2D Plano Unibersal	

		(COMMAND "COLOR" Co1 "3DCARA" K1X K2X K4X K3X "")

		;	CAMBIA VARIABLES

		(SETQ  PP0 K4X  PPX K3X)


	) ; repeat


	;	PARANDO																						
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;cierre DEFUN DIREC-ALA-74

;																									
